#pragma rtGlobals=1		// Use modern global access method.



//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												ANGLE - ENERGY
//-------------------------------------------------------------------------------------------------------------------------------------------------------------    
Proc AngleEnergy(particle)
	String particle
	
	variable WaveSize
	WaveSize=numpnts($("x_"+particle))

	make/O/D/N=(Wavesize) $("thet_"+particle),$("phi_"+particle),$("dvthet_"+particle),$("dvphi_"+particle)
	make/O/D/N=(Wavesize) $("Etrans_"+particle),$("Elong_"+particle),$("E_"+particle)
	
	// Angle
	$("thet_"+particle)=atan2(sqrt($("py_"+particle)^2+$("pz_"+particle)^2),$("px_"+particle))
	$("phi_"+particle)=atan2($("pz_"+particle),$("py_"+particle))	
	$("dvthet_"+particle)=atan2(sqrt($("px_"+particle)^2+$("py_"+particle)^2), $("pz_"+particle) )
	$("dvphi_"+particle)=atan2($("py_"+particle),$("px_"+particle))	
	
	// Energy
	$("Etrans_"+particle)=($("px_"+particle)^2+$("py_"+particle)^2)/1000
	$("Elong_"+particle)=($("pz_"+particle)^2)/1000
	$("E_"+particle)= ($("Etrans_"+particle))+($("Elong_"+particle))

	Histo_AngleEnergy(particle, "w_e",0,10,40)    
End

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												CORRELATION
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
Proc Correlation(particle1,particle2)
	String particle1,particle2
	
	variable WaveSize
	WaveSize=numpnts($("x_"+particle1))
	make/O/D/N=(Wavesize) $("Dphi_"+particle1+particle2),$("Dthet_"+particle1+particle2)
	make/O/D/N=(Wavesize) $("Dphi_"+particle2+particle1),$("Dthet_"+particle2+particle1)   //8/01/05
	make/O/D/N=(Wavesize) $("thet_"+particle1+particle2),$("Etot_"+particle1+particle2)

	$("Dphi_"+particle1+particle2)=$("phi_"+particle2)-$("phi_"+particle1)
	$("Dthet_"+particle1+particle2)=$("thet_"+particle2)-$("thet_"+particle1)
	
	$("Dphi_"+particle2+particle1)=$("phi_"+particle1)-$("phi_"+particle2)		//8/01/05
	$("Dthet_"+particle2+particle1)=$("thet_"+particle1)-$("thet_"+particle2)      //8/01/05
	
	thet12($("px_"+particle1),$("py_"+particle1),$("pz_"+particle1),$("px_"+particle2),$("py_"+particle2),$("pz_"+particle2),$("thet_"+particle1+particle2))
	$("Etot_"+particle1+particle2)=($("E_"+particle1))+($("E_"+particle2))

	Histo_Correlation(particle1,particle2, "",20,20,20,20,30)
End

//-------------------------------------------------------------------------------------------------------------------------------------------------------------       
//												MUTUAL ANGLE
//-------------------------------------------------------------------------------------------------------------------------------------------------------------  
function thet12(px1,py1,pz1,px2,py2,pz2,w)
	wave px1,py1,pz1,px2,py2,pz2,w
	w= acos((px1*px2+py1*py2+pz1*pz2)/(sqrt((px1^2+py1^2+pz1^2)*(px2^2+py2^2+pz2^2))))
end

////-------------------------------------------------------------------------------------------------------------------------------------------------------------       
////												PONDERATION
////-------------------------------------------------------------------------------------------------------------------------------------------------------------  
//function ponder1D(w)
//	wave w
//	string Name
//	variable x0, dx
//	x0=leftx(w)
//	dx=deltax(w)
//	name=nameofwave(w)
//	duplicate/O w, $(name+"_pond")
//	execute(name+"_pond="+name+"/abs(sin(x))")
//	execute(name+"_pond="+name+"_pond/area("+name+"_pond,0,Inf)*area("+name+",0,Inf)")
//end
////-------------------------------------------------------------------------------------------------------------------------------------------------------------       
////												InvertSum
////-------------------------------------------------------------------------------------------------------------------------------------------------------------  
//function InvertSum(w1,w2)
//	wave w1,w2
//	variable i,size=numpnts(w1)
//	for (i=0;i<size;i+=1)
//		w1[i]+=w2[size-i]
//	endfor
//end
////---------------------------------------------------------------------------------------------------------------------------
////												Symmetrize
////-------------------------------------------------------------------------------------------------------------------------------------------------------------  
//function Symmetrize(w1,w2)
//	wave w1,w2
//	variable i, mid, size=numpnts(w1)
//	mid=ceil(size/2)
//	w1=0
//	for (i=0;i<mid;i+=1)
//		w1[i]+=0.5*(w2[i]+w2[size-i])
//	endfor
//	for (i=mid;i<size;i+=1)
//		w1[i]+=w1[size-i-1]
//	endfor
//end
